/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.dialog.ControlPanel;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.logo.util.Version;
import DE.siemens.ad.pdraw.app.LogoHelp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.help.DefaultHelpBroker;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class SplittedDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected JPanel inputPane;
    DataInputPanel fDataInputPanel;
    ControlPanel fControlPanel;
    JPanel controlPane;
    protected static HashMap cBoundsDict = new HashMap();
    private boolean fConsiderPreferedSize;
    private static boolean getVirtualBoundsFinished;

    private static String getIniFileName() {
        Version v = Version.getCurrentVersion();
        StringBuffer buffer = new StringBuffer(System.getProperty("user.home", "C:")).append("/.").append(v.getApplicationFileName()).append(v.getMajorVersion()).append(".").append(v.getMinorVersion()).append("/DialogValue.dat");
        return buffer.toString();
    }

    protected SplittedDlg(JFrame parent) {
        super(parent);
        this.initDialog();
    }

    protected SplittedDlg(JDialog parent) {
        super(parent);
        this.initDialog();
    }

    public static SplittedDlg create(Window parent, DataInputPanel panel) {
        if (parent == null) {
            parent = Application.getInstance().getWindow();
        }
        SplittedDlg splittedDlg = SplittedDlg.create(parent, true);
        splittedDlg.setDataInputPanel(panel);
        return splittedDlg;
    }

    public static SplittedDlg create(Window parent, DataInputPanel panel, int controlMode) {
        SplittedDlg splittedDlg = SplittedDlg.create(parent, panel);
        ControlPanel controlPanel = new ControlPanel(controlMode);
        splittedDlg.setControlPanel(controlPanel);
        splittedDlg.setDataInputPanel(panel);
        return splittedDlg;
    }

    public static SplittedDlg create(Window parent, boolean modal) {
        SplittedDlg splittedDlg = null;
        if (parent instanceof JFrame) {
            splittedDlg = new SplittedDlg((JFrame)parent);
        } else if (parent instanceof JDialog) {
            splittedDlg = new SplittedDlg((JDialog)parent);
        } else {
            throw new IllegalArgumentException("SplittedDialog can only created with a JFrame orJDialog as parent component.");
        }
        splittedDlg.setModal(modal);
        splittedDlg.setConsiderPreferedSize(false);
        return splittedDlg;
    }

    public void close() {
        try {
            DefaultHelpBroker helpBroker = LogoHelp.getHelpBroker();
            if (helpBroker.isDisplayed() && helpBroker.getWindowPresentation().getActivationWindow() == this.getParent()) {
                helpBroker.setDisplayed(false);
            }
        }
        catch (ProgramException e) {
            // empty catch block
        }
        try {
            cBoundsDict.put(this.getBoundsID(), this.getBounds());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.getDataInputPanel() != null) {
            this.getDataInputPanel().closeEvent();
        }
        this.dispose();
    }

    private String getBoundsID() {
        return this.getDataInputPanel().getBoundsID();
    }

    public static void saveValues() {
        try {
            FileOutputStream outStream = new FileOutputStream(SplittedDlg.getIniFileName());
            StorableOutput storable = new StorableOutput(outStream);
            Iterator iter = cBoundsDict.entrySet().iterator();
            storable.writeInt(cBoundsDict.size());
            while (iter.hasNext()) {
                Map.Entry element = iter.next();
                Object key = element.getKey();
                if (key instanceof String) {
                    storable.writeString((String)key);
                } else {
                    storable.writeString(((Class)key).getName());
                }
                storable.writeDouble(((Rectangle)element.getValue()).getX());
                storable.writeDouble(((Rectangle)element.getValue()).getY());
                storable.writeDouble(((Rectangle)element.getValue()).getWidth());
                storable.writeDouble(((Rectangle)element.getValue()).getHeight());
            }
            storable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadValues() {
        try {
            FileInputStream inStream = new FileInputStream(SplittedDlg.getIniFileName());
            StorableInput storable = new StorableInput(inStream);
            int size = storable.readInt();
            while (size-- > 0) {
                String key = storable.readString();
                Rectangle rect = new Rectangle((int)storable.readDouble(), (int)storable.readDouble(), (int)storable.readDouble(), (int)storable.readDouble());
                cBoundsDict.put(key, rect);
            }
            inStream.close();
        }
        catch (Exception e) {
            System.out.print("SplittedDlg.loadValues(): ");
            System.out.println(e);
        }
    }

    public void closeDialogWithQuery() {
        int rw;
        if (this.getDataInputPanel().checkChanged() && (rw = new LogoError((Component)this, "dialog.parameter.error.valueChanged", "Values have been changed. Do you want to save the changes?", 3, 2).display()) == 2) {
            if (!this.getDataInputPanel().checkFieldContents()) {
                this.toFront();
                return;
            }
            this.getDataInputPanel().storeFieldContents();
        }
        this.close();
    }

    public void closePressed(WindowEvent event) {
        if (this.getControlPanel() != null) {
            this.getControlPanel().setResult(2);
        }
        this.close();
    }

    public JPanel getControlPane() {
        return this.controlPane;
    }

    public ControlPanel getControlPanel() {
        return this.fControlPanel;
    }

    public DataInputPanel getDataInputPanel() {
        return this.fDataInputPanel;
    }

    public JPanel getInputPane() {
        return this.inputPane;
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        preferredSize.width = Math.min(preferredSize.width, screenSize.width);
        preferredSize.height = Math.min(preferredSize.height, screenSize.height);
        return preferredSize;
    }

    private void initDialog() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.setVisible(false);
        this.setSize(288, 346);
        this.inputPane = new JPanel();
        this.inputPane.setLayout(null);
        this.inputPane.setBounds(0, 0, 288, 345);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.inputPane, gbc);
        this.getContentPane().add(this.inputPane);
        JSeparator separator = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)separator, gbc);
        this.controlPane = new JPanel(new FlowLayout(3, 1, 1));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        gbc.fill = 0;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.controlPane, gbc);
        this.getContentPane().add(this.controlPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                SplittedDlg.this.closePressed(we);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (SplittedDlg.this.getControlPanel() != null) {
                    SplittedDlg.this.getControlPanel().setResult(2);
                }
                SplittedDlg.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void disableEscKey() {
        this.getRootPane().registerKeyboardAction(null, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void setControlPanel(ControlPanel controlPanel) {
        controlPanel.setSplittedDlg(this);
        this.getControlPane().add(controlPanel);
        this.fControlPanel = controlPanel;
        if (controlPanel.getControlButton(1) != null) {
            JButton okButton = controlPanel.getControlButton(1);
            this.getRootPane().setDefaultButton(okButton);
            this.getDataInputPanel().setOkButton(okButton);
        }
    }

    public void setDataInputPanel(DataInputPanel dip) {
        if (this.fDataInputPanel != null) {
            this.getInputPane().remove(this.fDataInputPanel);
        }
        this.getInputPane().setLayout(new BorderLayout());
        this.getInputPane().add(dip);
        this.fDataInputPanel = dip;
    }

    public void showNotCenterd() {
        try {
            this.prepareDialog();
        }
        catch (ProgramException e) {
            String s = e.getUser();
            if (s != null) {
                new LogoError(this, s).display();
            }
            return;
        }
        this.setBounds(false);
        this.showDialog();
    }

    protected void prepareDialog() throws ProgramException {
        if (this.fDataInputPanel != null) {
            if (this.getTitle() == null) {
                this.setTitle(this.fDataInputPanel.getTitle());
            }
            this.setResizable(this.fDataInputPanel.isResizable());
            this.fDataInputPanel.setLabels();
            this.fDataInputPanel.loadFieldContents();
        }
    }

    protected void showDialog() {
        super.show();
    }

    public void show() {
        try {
            this.prepareDialog();
        }
        catch (ProgramException e) {
            String s = e.getUser();
            if (s != null) {
                new LogoError(this.getParent(), s).display();
            }
            return;
        }
        this.setBounds(true);
        this.showDialog();
    }

    public void setBounds(boolean center) {
        Rectangle bounds = null;
        this.pack();
        if (this.getDataInputPanel() != null) {
            bounds = (Rectangle)cBoundsDict.get(this.getBoundsID());
        }
        if (bounds == null) {
            if (center) {
                this.center();
            }
            bounds = this.getBounds();
        } else if (this.fConsiderPreferedSize) {
            bounds = Util.getLarger(this.getWidth(), this.getHeight(), bounds);
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Rectangle screenBounds = getVirtualBoundsFinished ? SplittedDlg.getVirtualBounds() : new Rectangle(toolkit.getScreenSize());
        Insets insets = toolkit.getScreenInsets(this.getParent().getGraphicsConfiguration());
        screenBounds.width -= insets.left + insets.right;
        screenBounds.height -= insets.bottom + insets.top;
        int excessLength = bounds.y + bounds.height - screenBounds.height;
        if (excessLength > 0) {
            bounds.y = Math.max(0, bounds.y - excessLength);
            if (bounds.y == 0 && bounds.height > screenBounds.height) {
                bounds.height = screenBounds.height;
            }
        }
        if ((excessLength = bounds.x + bounds.width - screenBounds.width) > 0) {
            bounds.x = Math.max(0, bounds.x - excessLength);
            if (bounds.x == 0 && bounds.width > screenBounds.width) {
                bounds.width = screenBounds.width;
            }
        }
        if (bounds.x < insets.left) {
            bounds.x = insets.left;
        }
        if (bounds.y < insets.top) {
            bounds.y = insets.top;
        }
        this.setBounds(bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void center() {
        SplittedDlg splittedDlg = this;
        synchronized (splittedDlg) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(Math.max(0, bounds.x + (bounds.width - abounds.width) / 2), Math.max(0, bounds.y + (bounds.height - abounds.height) / 2));
        }
    }

    public static void removeIniFile() {
        File file = new File(SplittedDlg.getIniFileName());
        if (file.exists()) {
            file.delete();
        }
    }

    public boolean isConsiderPreferedSize() {
        return this.fConsiderPreferedSize;
    }

    public void setConsiderPreferedSize(boolean considerPreferedSize) {
        this.fConsiderPreferedSize = considerPreferedSize;
    }

    public static Rectangle getVirtualBounds() {
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                virtualBounds = virtualBounds.union(gc[i].getBounds());
            }
        }
        getVirtualBoundsFinished = true;
        return virtualBounds;
    }

    static {
        LogoProperties logoProperties = LogoProperties.instance();
        if (logoProperties.getBooleanProperty("app.rememberDialogBounds", false) && new File(SplittedDlg.getIniFileName()).exists()) {
            SplittedDlg.loadValues();
        }
        getVirtualBoundsFinished = false;
    }
}

